(() => {
    "use strict";
    document.addEventListener('DOMContentLoaded', function() {
        const buttons = document.querySelectorAll('.promocode__button');

        buttons.forEach(function(button) {
            button.addEventListener('click', function() {
                const promocodeValue = button.previousElementSibling.textContent.trim();

                const tempTextarea = document.createElement('textarea');
                tempTextarea.value = promocodeValue;
                document.body.appendChild(tempTextarea);

                tempTextarea.select();
                document.execCommand('copy');
                document.body.removeChild(tempTextarea);

                const copySpan = button.querySelector('.copy');
                const copiedSpan = button.querySelector('.copied');
                copySpan.style.display = 'none';
                copiedSpan.style.display = 'inline';

                setTimeout(function() {
                    copySpan.style.display = 'inline';
                    copiedSpan.style.display = 'none';
                }, 2000);
            });
        });
    });


    new class {
        constructor(e) {
            this.header = document.querySelector(e), this.menuItems = this.header.querySelectorAll("li"), this.burger = this.header.querySelector(".header__burger"), this.langBlocks = this.header.querySelectorAll(".header__lang"), window.addEventListener("resize", (() => {
                window.matchMedia("(min-width: 1381px)").matches && this.closeBurger.call(this), this.updateHeaderHeight()
            }))
        }

        init() {
            this.initBurger(), this.initLangMenu(), this.updateHeaderHeight(), this.initSubMenus();
        }

        updateHeaderHeight() {
            const e = this.header.clientHeight;
            this.header.style.setProperty("--height", e + "px")
        }

        initBurger() {
            this.header.addEventListener("click", (e) => this.burgerHandler(e));
        }

        initSubMenus() {
            window.addEventListener("click", (e => this.subMenuHandler(e)))
        }

        subMenuHandler(event) {
            if (window.innerWidth <= 1380) {
                const menuItem = event.target.closest(".main-nav__item--has-children");
                if (menuItem) {
                    menuItem.classList.toggle("active");
                }
            }
        }

        initLangMenu() {
            this.langBlocks.forEach((e => {
                e.addEventListener("click", (() => this.langMenuHandler(e)))
            }))
        }

        burgerHandler(e) {
            e.target.closest(".header__burger") === this.burger && (this.header.classList.toggle("burger-active"), document.body.classList.toggle("no-scroll"))
        }

        langMenuHandler(e) {
            e.classList.toggle("active")
        }

        closeBurger() {
            this.header.classList.remove("burger-active"), document.body.classList.remove("no-scroll")
        }
    }

    (".header").init(), (() => {
            let e = document.querySelectorAll(".sf-link-h");
            e && e.forEach((e => {
                e.addEventListener("click", (function() {
                    let t = e.dataset.sfA;
                    t && (document.location.href = atob(t))
                }))
            }))

        })(),
        (() => {
            const e = document.querySelectorAll("[data-toc]");
            e && e.forEach((e => {
                e.addEventListener("click", (e => {
                    const t = e.currentTarget,
                        s = t.querySelector("[data-toc-title]");
                    e.target === s && t.classList.toggle("active")
                }))
            }))
        })();

    class e {
        constructor(e, t) {
            this.tabList = e, this.tabPaneList = t, this.init = this.init.bind(this), this.openTabPane = this.openTabPane.bind(this), this.closeAllTabPanes = this.closeAllTabPanes.bind(this), this.clearAllTabs = this.clearAllTabs.bind(this)
        }

        init() {
            this.tabList.forEach((e => {
                e.addEventListener("click", (() => {
                    this.clearAllTabs(), e.classList.add("active"), this.openTabPane(e.dataset.paneid)
                }))
            }))
        }

        openTabPane(e) {
            const t = [...this.tabPaneList].find((t => t.dataset.id === e));
            t && (this.closeAllTabPanes(), t.classList.add("active"))
        }

        closeAllTabPanes() {
            this.tabPaneList.forEach((e => {
                e.classList.remove("active")
            }))
        }

        clearAllTabs() {
            this.tabList.forEach((e => {
                e.classList.remove("active")
            }))
        }
    }

    // (() => {
    //     const t = document.querySelectorAll(".tabs-section");
    //     t && t.forEach((t => {
    //         const s = t.querySelectorAll(".tabs-section__tabs-list-btn"), n = t.querySelectorAll(".tabs-section__tab");
    //         new e(s, n).init()
    //     }))
    // })();
    (() => {
        const tabsSections = document.querySelectorAll(".tabs-section");
        tabsSections && tabsSections.forEach((section) => {
            const tabButtons = section.querySelectorAll(".tabs-section__tabs-list-btn");
            const tabsContent = section.querySelectorAll(".tabs-section__tab");
            tabsContent[0].classList.add("active");
            new e(tabButtons, tabsContent).init();
            for (let i = 1; i < tabButtons.length; i++) {
                tabButtons[i].classList.remove("active");
            }
            for (let i = 1; i < tabsContent.length; i++) {
                tabsContent[i].classList.remove("active");
            }
            tabButtons[0].addEventListener("click", () => {
                tabButtons.forEach((button) => {
                    button.classList.remove("active");
                });
                tabsContent.forEach((content) => {
                    content.classList.remove("active");
                });
                tabButtons[0].classList.add("active");
                tabsContent[0].classList.add("active");
            });
        });
    })();
    var l = document.querySelector(".scroll-top__button");

    l && l.addEventListener("click", function() {
        window.scrollTo({
            top: 0,
            behavior: "smooth"
        });
    });

    document.addEventListener("scroll", function() {
        var i = document.querySelector(".scroll-top__button");
        if (window.scrollY > 400) {
            l && (l.style.visibility = "visible");
            i && (i.style.visibility = "visible");
        } else {
            l && (l.style.visibility = "hidden");
            if (i) {
                i.style.visibility = "hidden";
                i.classList.remove("_active");
            }
        }
    });
    const t = new class {
        constructor(e) {
            this.popup = e, this.popupBg = this.popup.querySelector(".popup__bg"), this.popupText = this.popup.querySelector(".popup__text"), this.popupHandler = this.popupHandler.bind(this), this.popup.addEventListener("click", this.popupHandler)
        }

        popupHandler(e) {
            (e.target === this.popupBg || e.target.closest(".js-cross")) && this.closePopup()
        }

        openPopup(e) {
            e && (this.popupText.insertAdjacentHTML("afterbegin", e), this.reinitSF()), this.popup.classList.add("open"), document.body.classList.add("no-scroll")
        }

        closePopup() {
            this.popup.classList.remove("open"), document.body.classList.remove("no-scroll"), this.cleanPopup()
        }

        cleanPopup() {
            this.popupText.innerText = ""
        }

        reinitSF() {
            let e = this.popupText.querySelectorAll(".sf-link");
            e && e.forEach((e => {
                e.addEventListener("click", (function() {
                    let t = e.dataset.sfA;
                    t && (document.location.href = atob(t))
                }))
            }))

        }
    }(document.querySelector(".popup"));
    (() => {
        const e = document.querySelectorAll(".hero-section");
        0 !== e.length && e.forEach((e => {
            const s = e.querySelectorAll("[data-bonus]");
            0 !== s.length && s.forEach((e => {
                const s = e.querySelector("[data-popupbtn]"),
                    n = e.querySelector("[data-bonuscontent]");
                let i = null;
                n && (i = n.innerHTML), n && s.addEventListener("click", (() => t.openPopup(i)))
            }))
        }))
    })(),
    (() => {
        const sections = document.querySelectorAll(".bonuses-section");
        sections.forEach((section) => {
            const btns = section.querySelectorAll("[data-popupbtn]");
            const content = section.querySelector("[data-bonuscontent]");
            btns.forEach((btn) => {
                btn.addEventListener("click", () => {
                    let htmlContent = content.innerHTML;
                    t.openPopup(htmlContent);
                });
            });
        });
    })();

    document.querySelectorAll(".winners-section").forEach((e => {
        e.querySelectorAll(".winners-section__winner-nickname").forEach((e => {
            let t = [...e.textContent].slice(0, 3).join("") + "***";
            e.textContent = t
        }))
    })), (() => {
        const e = document.querySelectorAll(".bp-bonuses-section");
        0 !== e.length && e.forEach((e => {
            const s = e.querySelectorAll("[data-bonus]");
            0 !== s.length && s.forEach((e => {
                const s = e.querySelector("[data-popupbtn]"),
                    n = e.querySelector("[data-bonuscontent]");
                let i = null;
                n && (i = n.innerHTML), n && s.addEventListener("click", (() => t.openPopup(i)))
            }))
        }))
    })(), document.addEventListener("DOMContentLoaded", (() => {}))
    document.addEventListener("DOMContentLoaded", function() {
        let sfLinks = document.querySelectorAll(".sf-link");
        sfLinks.forEach(function(link) {
            link.addEventListener("click", function() {
                let encodedUrl = this.dataset.sfA;
                if (encodedUrl) {
                    window.location.href = encodedUrl;
                }
            });
        });
    });

    class HorizontalScroll {
        constructor(element) {
            this.scrollContainer = element;
            this.isCalculated = true;
            this.horizontalScrollInit = this.horizontalScrollInit.bind(this);
            this.setActiveItem = this.setActiveItem.bind(this);
        }

        horizontalScrollInit() {
            const e = this.scrollContainer;
            if (e) {
                e.style.overflowX = 'auto';

                let t, s, i = false;
                const l = 1;

                e.addEventListener("mousedown", (event) => {
                    i = true;
                    document.body.style.cursor = "grabbing";
                    t = event.pageX - e.offsetLeft;
                    s = e.scrollLeft;
                });

                e.addEventListener("mousemove", (event) => {
                    if (!i) return;
                    event.preventDefault();
                    const r = (event.pageX - e.offsetLeft - t) * l;
                    e.scrollLeft = s - r;
                    this.isCalculated && this.setActiveItem();
                });

                e.addEventListener("mouseup", () => {
                    i = false;
                    document.body.style.cursor = "default";
                });

                e.addEventListener("mouseleave", () => {
                    i = false;
                    document.body.style.cursor = "default";
                });

                e.addEventListener("wheel", (event) => {
                    if (e.scrollWidth > e.clientWidth) {
                        event.preventDefault();
                        e.scrollLeft += event.deltaY;
                        if (this.isCalculated) {
                            this.setActiveItem();
                        }
                    }
                });

                e.addEventListener("scroll", () => {
                    if (e.scrollWidth > e.clientWidth && this.isCalculated) {
                        this.setActiveItem();
                    }
                });
            }
            return this;
        }

        setActiveItem() {

        }
    }

    const elements = document.querySelectorAll(".screenshot-gallery__list");

    elements.forEach(element => {
        new HorizontalScroll(element).horizontalScrollInit();
    });

    const demo_btn = document.querySelector('.demo-btn')

    if (demo_btn) {
        const $game = document.querySelector('.game');
        const $close_btn = $game.querySelector('.game__close')
        const $game_preview = $game.querySelector('.game__preview');
        const gameSourceHTML = $game_preview.innerHTML;

        demo_btn.onclick = (e) => {
            const gameUrl = e.target.dataset.embed;
            let gameIframe = document.createElement('iframe');
            gameIframe.setAttribute('allowfullscreen', '')
            gameIframe.setAttribute('allow', 'autoplay');
            gameIframe.setAttribute('high', '100%');
            gameIframe.setAttribute('src', gameUrl);

            $game_preview.innerHTML = gameIframe.outerHTML;
            $game.classList.toggle('_active', true)
        }

        $close_btn.onclick = (e) => {
            $game_preview.innerHTML = gameSourceHTML;
            $game.classList.toggle('_active', false)
        }
    }

    // const $slots_demo_btns = document.querySelectorAll(".slots__demo")
    // const $popup = document.querySelector(".slots-popup")
    // if ($slots_demo_btns && $popup) {
    //     $slots_demo_btns.forEach((demo_btn) => {
    //         demo_btn.onclick = (e) => {
    //             $popup.classList.toggle('_active', true)

    //             let fr = document.createElement("iframe");
    //             fr.src = e.target.dataset.embed;

    //             const $iframeContainer = $popup.querySelector('.slots-popup__body');
    //             $iframeContainer.innerHTML = fr.outerHTML;

    //             const $btn = e.target.previousElementSibling
    //             if ($btn) {
    //                 if ($btn.classList.contains('slots__button')) {
    //                     $popup.querySelector('.slots-popup__buttons').innerHTML = $btn.outerHTML
    //                     const $link_btn = $popup.querySelector('.slots-popup__buttons .slots__button')
    //                     $link_btn.onclick = e => {
    //                         var t = e.target.dataset.sfA;
    //                         t && (document.location.href = t)
    //                     }
    //                 }
    //             }

    //             const title = e.target.dataset.title
    //             if (title) $popup.querySelector('.slots-popup__title').innerText = title
    //         }
    //     })
    // }

    // const $cross = document.querySelector(".slots-popup__cross")
    // if ($cross) {
    //     $cross.onclick = (e) => {
    //         $popup.classList.toggle('_active', false)
    //         $popup.querySelector('.slots-popup__body').innerHTML = '';
    //         $popup.querySelector('.slots-popup__buttons').innerHTML = '';
    //         $popup.querySelector('.slots-popup__title').innerHTML = '';
    //     }
    // }

    // if ($popup) {
    //     $popup.onclick = (e) => {
    //         if (e.target.classList.contains('slots-popup')) {
    //             e.target.classList.toggle('_active', false)
    //             $popup.querySelector('.slots-popup__body').innerHTML = '';
    //             $popup.querySelector('.slots-popup__buttons').innerHTML = '';
    //             $popup.querySelector('.slots-popup__title').innerHTML = '';
    //         }
    //     }
    // }

    const copy_btns = document.querySelectorAll('.copy-btn');

    if (copy_btns) {
        copy_btns.forEach(copy_btn => {
            copy_btn.onclick = e => {
                const promo = e.target.closest('.promocode').querySelector('.promocode-field').innerText
                const button_inner = e.target.innerHTML

                let tmp = document.createElement('textarea')
                tmp.value = promo
                e.target.appendChild(tmp)
                tmp.select()
                document.execCommand('copy')
                tmp.remove()
                e.target.textContent = 'COPIED'
                setTimeout(() => {
                    e.target.innerHTML = button_inner
                }, 3000)
            }
        })
    }

})();


class BookmakerRatingToggler {
    constructor() {
        this.buttons = document.querySelectorAll('.bookmaker-rating .bookmaker-rating__open');
        this.init();
    }

    init() {
        if (!this.buttons.length) {
            console.warn('Кнопки рейтинга букмекеров не найдены');
            return;
        }

        this.buttons.forEach(btn => {
            btn.addEventListener('click', this.toggleParent.bind(this));
        });
    }

    toggleParent(event) {
        const parent = event.currentTarget.closest('.bookmaker-rating__item-block');

        if (!parent) {
            console.warn('Родительский блок букмекера не найден');
            return;
        }

        parent.classList.toggle('active');
    }
}

// Использование
document.addEventListener('DOMContentLoaded', () => {
    new BookmakerRatingToggler();
});