
let exchangeRate = {
  usd: 1,
  rub: 90
};

let currentCurrency = "usd";

function convertCurrency(value) {
  return Math.round(value * exchangeRate[currentCurrency]);
}

function formatCurrency(value) {
  return currentCurrency === "rub" ? `${convertCurrency(value)} ₽` : `$${value}`;
}

document.getElementById("currencySelect").addEventListener("change", (e) => {
  currentCurrency = e.target.value;
  updateDisplayedCurrency();
});

function updateDisplayedCurrency() {
  const balanceDisplay = document.getElementById("balanceDisplay");
  if (balanceDisplay) {
    const rawValue = parseInt(balanceDisplay.getAttribute("data-raw")) || 100;
    balanceDisplay.textContent = formatCurrency(rawValue);
  }
}

window.addEventListener("DOMContentLoaded", () => {
  updateDisplayedCurrency();
});
