
const translations = {
  en: {
    start: "Start Game",
    balance: "Balance",
    bet: "Bet",
    win: "Win"
  },
  ru: {
    start: "Начать игру",
    balance: "Баланс",
    bet: "Ставка",
    win: "Выигрыш"
  }
};

function applyLanguage(lang) {
  document.querySelectorAll("[data-i18n]").forEach(el => {
    const key = el.getAttribute("data-i18n");
    el.textContent = translations[lang][key] || key;
  });
}

document.getElementById("langSelect").addEventListener("change", (e) => {
  applyLanguage(e.target.value);
});

window.addEventListener("DOMContentLoaded", () => {
  applyLanguage(document.getElementById("langSelect").value);
});
